/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.catnip.data.Couple;
import net.createmod.ponder.api.registration.LangRegistryAccess;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.registration.PonderSceneRegistry;
import net.minecraft.class_1074;
import net.minecraft.class_2960;

public class PonderLocalization
implements LangRegistryAccess {
    public static final String LANG_PREFIX = "ponder.";
    public static final String UI_PREFIX = "ui.";
    public final Map<class_2960, String> shared = new HashMap<class_2960, String>();
    public final Map<class_2960, Couple<String>> tag = new HashMap<class_2960, Couple<String>>();
    public final Map<class_2960, Map<String, String>> specific = new HashMap<class_2960, Map<String, String>>();

    public void clearAll() {
        this.shared.clear();
        this.tag.clear();
        this.specific.clear();
    }

    public void clearShared() {
        this.shared.clear();
    }

    public void registerShared(class_2960 key, String enUS) {
        this.shared.put(key, enUS);
    }

    public void registerTag(class_2960 key, String title, String description) {
        this.tag.put(key, Couple.create(title, description));
    }

    public void registerSpecific(class_2960 sceneId, String key, String enUS) {
        this.specific.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    protected static String langKeyForShared(class_2960 k) {
        return k.method_12836() + ".ponder.shared." + k.method_12832();
    }

    protected static String langKeyForTag(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832();
    }

    protected static String langKeyForTagDescription(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832() + ".description";
    }

    protected static String langKeyForSpecific(class_2960 sceneId, String k) {
        return sceneId.method_12836() + ".ponder." + sceneId.method_12832() + "." + k;
    }

    @Override
    public String getShared(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? this.shared.get(key) : "unregistered shared entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    @Override
    public String getShared(class_2960 key, Object ... params) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? String.format(this.shared.get(key), params) : "unregistered shared entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForShared(key), (Object[])params);
    }

    @Override
    public String getTagName(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getFirst() : "unregistered tag entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    @Override
    public String getTagDescription(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getSecond() : "unregistered tag entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(class_2960 sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            try {
                return this.specific.get(sceneId).get(k);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(class_2960 sceneId, String k, Object ... params) {
        if (PonderIndex.editingModeActive()) {
            try {
                return String.format(this.specific.get(sceneId).get(k), params);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])params);
    }

    private void recordGeneral(BiConsumer<String, String> consumer) {
        this.addGeneral(consumer, "ui.hold_to_ponder", "Hold [%1$s] to Ponder");
        this.addGeneral(consumer, "ui.subject", "Subject of this scene");
        this.addGeneral(consumer, "ui.pondering", "Pondering about...");
        this.addGeneral(consumer, "ui.pondering_tag", "Pondering about...");
        this.addGeneral(consumer, "ui.identify_mode", "Identify mode active.\nUnpause with [%1$s]");
        this.addGeneral(consumer, "ui.associated", "Associated Entries");
        this.addGeneral(consumer, "ui.close", "Close");
        this.addGeneral(consumer, "ui.identify", "Identify");
        this.addGeneral(consumer, "ui.next", "Next Scene");
        this.addGeneral(consumer, "ui.next_up", "Up Next:");
        this.addGeneral(consumer, "ui.previous", "Previous Scene");
        this.addGeneral(consumer, "ui.replay", "Replay");
        this.addGeneral(consumer, "ui.think_back", "Think Back");
        this.addGeneral(consumer, "ui.slow_text", "Comfy Reading");
        this.addGeneral(consumer, "ui.exit", "Exit");
        this.addGeneral(consumer, "ui.welcome", "Welcome to Ponder");
        this.addGeneral(consumer, "ui.categories", "Available Categories for %1$s");
        this.addGeneral(consumer, "ui.index_description", "Click one of the icons below to learn about its associated Items and Blocks");
        this.addGeneral(consumer, "ui.index_title", "Ponder Index");
    }

    private void addGeneral(BiConsumer<String, String> consumer, String key, String enUS) {
        consumer.accept(LANG_PREFIX + key, enUS);
    }

    public void generateSceneLang() {
        PonderIndex.getSceneAccess().getRegisteredEntries().forEach(entry -> PonderSceneRegistry.compileScene(this, (StoryBoardEntry)entry.getValue(), null));
    }

    @Override
    public void provideLang(String modId, BiConsumer<String, String> consumer) {
        PonderIndex.registerAll();
        PonderIndex.gatherSharedText();
        this.generateSceneLang();
        if (modId.equals("ponder")) {
            this.recordGeneral(consumer);
        }
        this.shared.forEach((k, v) -> {
            if (k.method_12836().equals(modId)) {
                consumer.accept(PonderLocalization.langKeyForShared(k), (String)v);
            }
        });
        this.tag.forEach((k, v) -> {
            if (k.method_12836().equals(modId)) {
                consumer.accept(PonderLocalization.langKeyForTag(k), (String)v.getFirst());
                consumer.accept(PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
            }
        });
        this.specific.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(modId)).sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> consumer.accept(PonderLocalization.langKeyForSpecific((class_2960)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
    }
}

